﻿/*
	VERSION:		1.8
	1.8		Added "onTalk" event via sendEvent()  (if it already exists)
	1.7		Changed hit-test to use the sprite's "hit" hit-box movieClip
	1.6		Added an optional check for  RAM.keys.talk  which overrides the talkKey passed to this while it exists
	
	USAGE:
		#include "talk.as"
		player_mc.talk_obj = makeTalk( player_mc,  player_mc.image_mc,  spriteLayer_mc );
		
	PARAMETERS:
		player_mc					Player's movieClip.  Needed for position.
		playerImage_mc		Player's sprite system.  Needed for direction.
		spriteLayer_mc		Sprite movieClip.  Needed to search for sprites.  This can also be an array of references.
		
	SETTINGS:
		talk_key				The "talk" button.
		
	WHAT THIS DOES:
		This calls the  talk()  function 
		within whatever movieClip is in front of the player.
		
	EVENTS:
		"onTalk"				Fires right before a sprite's talk() is called  (requires sendEvent() to already exist in talk.as parent)
*/
makeTalk = function( player_mc, playerImage_mc, spriteLayer_mc, talkKey, xOffset, yOffset )
{
	// resolve optional parameters
	talkKey = (talkKey) ? talkKey : Key.SPACE;
	
	// create container
	var _this = new Object();
	
	// store parameters
	_this.player_mc = player_mc;
	_this.playerImage_mc = playerImage_mc;
	_this.spriteLayer_mc = spriteLayer_mc;
	_this.xOffset = (xOffset!=undefined) ? xOffset : 0;
	_this.yOffset = (yOffset!=undefined) ? yOffset : 0;
	
	// settings
	_this.talk_key = talkKey;
	
	// prevent repeated talking
	_this.lastKey = false;
	
	
	_this.loop = function()
	{
		if( Key.isDown( RAM.keys.talk || _this.talk_key) )
		{
			if( _this.lastKey == false )
			{
				_this.lastKey = true;
				// get direction
				switch( _this.playerImage_mc.internal.direction)
				{
					case 0:		// up
						var x = 0;
						var y = -16;
					break;
					case 1:		// right
						var x = 16;
						var y = 0;
					break;
					case 2:		// down
						var x = 0;
						var y = 16;
					break;
					case 3:		// left
						var x = -16;
						var y = 0;
					break;
				}// switch:  direction
				
				// set the search location
				var xSearch = _this.player_mc._x + x +_this.xOffset;
				var ySearch = _this.player_mc._y + y +_this.yOffset;
				var search_p = new flash.geom.Point(xSearch, ySearch);
				SPRITES.localToGlobal(search_p);
				
				// detect sprite
				for( var nam in _this.spriteLayer_mc )
				{
					var thisSprite = _this.spriteLayer_mc[nam];
					/*
					if( xSearch > thisSprite._x-8  &&
							ySearch > thisSprite._y-8  &&
							xSearch < thisSprite._x+8  &&
							ySearch < thisSprite._y+8 )
					*/
					if( thisSprite.hit.hitTest( search_p.x, search_p.y, false ) )
					{
						// make that sprite talk
						//trace("talking to: "+nam);
						sendEvent("onTalk", {sprite:thisSprite});
						thisSprite.talk();
					}// if:  sprite detected
				}// for...in:  sprite layer
			}// if:  talk_key wasn't already being held
		}// if:  talk_key
		else
		{// if:  talk_key is NOT being pressed
			_this.lastKey = false;
		}// if:  talk_key is NOT being pressed
	}// loop()
	_this.loopInterval = setInterval( _this.loop, 33 );		// 30 FPS
	
	
	// return this system
	return _this;
}// makeTalk()